//
//  DHDUSBProController.h
//  DHDMX
//
//  Created by Douglas Heriot on 17/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDUSBProIOControllerDelegate.h"

@interface DHDUSBProIOController : NSObject
{
@private
	void* ftHandle;
	dispatch_queue_t queue;
	dispatch_source_t timer;
	
	id<DHDUSBProIOControllerDelegate> _delegate;
	
	BOOL _supportsMultipleUniverseOutput;
	NSUInteger _universes;
	
	BOOL _open;
	
	NSString *_identifier;
	NSString *_serialString;
	NSUInteger _serialNumber;
	
	uint16_t _manufacturerESTAID;
	uint16_t _deviceTypeId;
	NSString *_deviceName;
	NSString *_deviceManufacturer;
	
	uint8_t _firmwareVersion;
	uint64_t _breakTime;
	uint64_t _MABTime;
	uint8_t _outputRate;
	
	NSData *_userData;
	
	NSMutableData *_previousData;
}

@property (unsafe_unretained) id<DHDUSBProIOControllerDelegate> delegate;

@property (readonly) NSUInteger universes;
@property (readonly, getter=isOpen) BOOL open;

@property (readonly, copy) NSString *identifier;
@property (readonly, copy) NSString *serialString;
@property (readonly) NSUInteger serialNumber;

@property (readonly) uint16_t manufacturerESTAID;
@property (readonly) uint16_t deviceTypeId;
@property (readonly, copy) NSString *deviceName;
@property (readonly, copy) NSString *deviceManufacturer;

@property (readonly) uint8_t firmwareVersion;
@property (readonly) uint64_t breakTime;
@property (readonly) uint64_t MABTime;
@property (readonly) uint8_t outputRate;

@property (retain) NSData *userData;

// Designated initialiser
- (id)initWithIdentifier:(NSString *)identifier;
// (-init just calls this, with any identifier found)

- (void)open;
- (void)close;
- (void)closeSynchronously;

- (void)sendDMX:(NSData *)dmx;
- (void)enableReceiveDMX;

- (void)setNewBreakTime:(uint64_t)nanoseconds;
- (void)setNewMABTime:(uint64_t)nanoseconds;
- (void)setNewOutputRate:(uint64_t)Hz;

@end
